const PromoCode = require("../promoCode/promoCode.model");

//create promoCode by admin
exports.store = async (req, res) => {
  try {
    if (!req.body.promoCode || !req.body.discountType || !req.body.discountAmount || !req.body.conditions) {
      return res.status(200).json({ status: false, message: "Oops ! Invalid details." });
    }

    const promoCode = new PromoCode();

    promoCode.promoCode = req.body.promoCode;
    promoCode.discountType = req.body.discountType;
    promoCode.discountAmount = parseInt(req.body.discountAmount);
    promoCode.minOrderValue = parseInt(req.body.minOrderValue);
    promoCode.conditions = req.body.conditions.split(",");

    await promoCode.save();

    return res.status(200).json({
      status: true,
      message: "PromoCode generated by admin.",
      promoCode,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      status: false,
      error: error.message || "Internal Server error",
    });
  }
};

//update promoCode by admin
exports.update = async (req, res) => {
  try {
    if (!req.query.promoCodeId) {
      return res.status(200).json({ status: false, message: "promoCodeId must be requried." });
    }

    const promoCode = await PromoCode.findById(req.query.promoCodeId);
    if (!promoCode) {
      return res.status(200).json({ status: false, message: "promoCode does not found!!" });
    }

    promoCode.promoCode = req.body.promoCode ? req.body.promoCode : promoCode.promoCode;
    promoCode.discountType = parseInt(req.body.discountType) ? parseInt(req.body.discountType) : promoCode.discountType;
    promoCode.discountAmount = parseInt(req.body.discountAmount) ? parseInt(req.body.discountAmount) : promoCode.discountAmount;
    promoCode.minOrderValue = parseInt(req.body.minOrderValue) ? parseInt(req.body.minOrderValue) : promoCode.minOrderValue;

    const Conditions = req.body.conditions.toString();
    promoCode.conditions = Conditions ? Conditions.split(",") : promoCode.conditions;

    await promoCode.save();

    return res.status(200).json({
      status: true,
      message: "promoCode updated by admin.",
      promoCode,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      status: false,
      error: error.message || "Internal Server Error",
    });
  }
};

//delete promoCode by admin
exports.destroy = async (req, res) => {
  try {
    if (!req.query.promoCodeId) {
      return res.status(200).json({ status: false, message: "promoCodeId must be requried." });
    }

    const promoCode = await PromoCode.findById(req.query.promoCodeId);
    if (!promoCode) {
      return res.status(200).json({ status: false, message: "promoCode does not found." });
    }

    await promoCode.deleteOne();

    return res.status(200).json({ status: true, message: "promoCode deleted by admin." });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      status: false,
      error: error.message || "Internal Server Error",
    });
  }
};

//get all promoCode for admin
exports.index = async (req, res) => {
  try {
    const promoCode = await PromoCode.find().sort({ createdAt: 1 });
    if (!promoCode) {
      return res.status(200).json({ status: false, message: "No data found." });
    }

    return res.status(200).json({
      status: true,
      message: "get all promoCode Successfully.",
      promoCode,
    });
  } catch (error) {
    console.log(error);
    return res.status(500).json({
      status: false,
      error: error.message || "Internal Server Error",
    });
  }
};
